function DecImg = DeconvSub(handles)

global tracer

if isempty(tracer)
    tracer=1;
else
    DecImg = [];
    clearvars -except DecImg
    return
end

%% Load File
image      = load(fullfile(tempdir,'ShowDeconv.mat')).DeconvImg;
DecSubLog  = load(fullfile(tempdir,'DeconvLog.mat')).DeconvLog ;
Fit        = load(fullfile(tempdir,'SubtrZLP.mat')).Data;
cutoff     = Fit{2};
clearvars Fit

%% Get Handles
Norm       = get(handles.ShowInt,'UserData');
Energies   = get(handles.ZLPAlign,'UserData');
Data       = get(handles.Background,'UserData');
Add        = load(fullfile(tempdir,'DecAdd.mat')).DecAdd;
Back       = Data{1};
Back1      = Data{2};
DecSubIter = str2double(get(handles.DecSubIter,'String'));
GPU        = get(handles.GPU,'Value');
Factor0    =  str2double(get(handles.SubDecFac1,'String'));
Factor1    =  str2double(get(handles.SubDecFac2,'String'));

%% Prepare Delta Peak
image(image<0)     = 0;
[~,Pos]            = min(abs(Energies),[],2);
clearvars Energies
PeakPos            = round(Pos/2);
image(:,:,PeakPos) = Norm - sum(image,3);
OrgLength          = size(image,3);
image              = cat(3,image,Add);
clearvars Add

Back1 = min(Back1,PeakPos-1);
%Back1 = min(Back1,cutoff(1));
clearvars cutoff

%% Create Kernel
% In order to get rid of the substrate spectrum in the spectrum of the structure of
% interest, it can be deconvolved. For the the kernel can be defined as the
% mean spectrum of the selected background region.
% For this to work propperly, the ZLP characteristic needs to be out of the
% spectra, as otherwise this would be inpropper ZLP deconvolution without ZLP subtraction (see ZLP deconvolution).
% The ZLP has to be replaced by a delta peak, with the hight being calculated as the
% difference between the respective spectrum and the overall intensity with ZLP.
% Here the integrated intensity map is utilized. The deconvolution then reduces the substrate spectrum inside all spectra,
% leaving only the spectrum of the structure of interest and the coupling of it with the substrate.

kernel             = image(Back(2):Back(4),Back(1):Back(3),:);
kernel             = kernel./sum(kernel,3);
kernel             = reshape(kernel,[size(kernel,1)*size(kernel,2),size(kernel,3)]);
kernel             = mean(kernel,1);
kernel             = circshift(kernel,-PeakPos+1,2);
clearvars PeakPos
Kernel             = zeros(size(image));
kernel             = reshape(kernel,[1,1,size(kernel,2)]);
Kernel(1,1,:)      = kernel./sum(kernel,3);
clearvars kernel


%% Normalize Image
image = image./Norm.*mean(Norm,'all');

%% ADMM
Sigma = std(image(:,:,1:Back1),[],'all');
if Sigma < 1
     image = image./Sigma;
     sigma = Sigma;
     Sigma = std(image(:,:,1:Back1),[],'all');
else
    sigma = 1;
end
clearvars cutoff Back1

Incr      = sqrt(sum(Kernel./sum(Kernel,'all'),'all'));

Lambda0   = Factor0./(2.*Incr.*Sigma);
Lambda1   = Factor1./(2.*Incr.*Sigma);

tic;
try
    switch GPU
        case 1
            [DecImg,DecSubIter]          = gpu_DecSub(image,Kernel,Sigma,Lambda0,Lambda1,DecSubIter);
        otherwise
            [DecImg,DecSubIter]          =     DecSub(image,Kernel,Sigma,Lambda0,Lambda1,DecSubIter);
    end
catch
    switch GPU
        case 1
            msgbox('Not enough RAM on GPU!')
        otherwise
            msgbox('Not enough RAM!')
    end
    DecImg=[];
end
toc;
if isempty(DecImg)
    clearvars -except DecImg
    clear global
    return
end


DecImg(:,:,1:Pos-1)  = 0;
DecImg               = DecImg(:,:,1:OrgLength);
DecImg               = DecImg.*Norm./mean(Norm,'all').*sigma;

%% Create Logbook
DecSubLog{1}     = strrep(DecSubLog{1},'Deconvolved','Deconv. Substrate');
DecSubLog{end+1} = [];
DecSubLog{end+1} = '-----------------------------------------------------------------------------';
DecSubLog{end+1} = [];
DecSubLog{end+1} = 'Substrate Deconvolution:';
DecSubLog{end+1} = ['NoiseModel: Gaussian | Iter: ' , num2str(DecSubIter) , '  |  Sigma: ' , num2str(Sigma) ,'  |  UserFactor0: ' ,num2str(Factor0),'  |  UserFactor1: ' ,num2str(Factor1)];
DecSubLog{end+1} = [];
DecSubLog{end+1} = ['Substrate defined via Edgepoints: [',num2str(Back(1)),' , ',num2str(Back(2)),' , ',num2str(Back(1)+Back(3)),' , ',num2str(Back(2)+Back(4)),' ]'];
save(fullfile(tempdir,'DecSubLog.mat'),'DecSubLog');

clearvars -except DecImg
end